@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.FilterableProperty.builder
import com.pulumi.azurenative.edgeorder.kotlin.enums.SupportedFilterTypes
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Different types of filters supported and its values.
 * @property supportedValues Values to be filtered.
 * @property type Type of product filter.
 */
public data class FilterableProperty(
    public val supportedValues: List<String>,
    public val type: Either<String, SupportedFilterTypes>,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.FilterableProperty> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.FilterableProperty =
        com.pulumi.azurenative.edgeorder.inputs.FilterableProperty.builder()
            .supportedValues(supportedValues.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(
                type.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FilterableProperty].
 */
@PulumiTagMarker
public class FilterablePropertyBuilder internal constructor() {
    private var supportedValues: List<String>? = null

    private var type: Either<String, SupportedFilterTypes>? = null

    /**
     * @param value Values to be filtered.
     */
    @JvmName("wvorvrjrsbabaydv")
    public suspend fun supportedValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.supportedValues = mapped
    }

    /**
     * @param values Values to be filtered.
     */
    @JvmName("tmrudtxlmxmnuiay")
    public suspend fun supportedValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.supportedValues = mapped
    }

    /**
     * @param value Type of product filter.
     */
    @JvmName("aihspbykoiqhovmd")
    public suspend fun type(`value`: Either<String, SupportedFilterTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value Type of product filter.
     */
    @JvmName("vjyiwhtqouvndmyy")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SupportedFilterTypes>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value Type of product filter.
     */
    @JvmName("utqygjbimaxthahu")
    public fun type(`value`: SupportedFilterTypes) {
        val toBeMapped = Either.ofRight<String, SupportedFilterTypes>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): FilterableProperty = FilterableProperty(
        supportedValues = supportedValues ?: throw PulumiNullFieldException("supportedValues"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
