@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.GetAddressPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property addressName The name of the address Resource within the specified resource group. address names must be between 3 and 24 characters in length and use any alphanumeric and underscore only.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAddressPlainArgs(
    public val addressName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.GetAddressPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.GetAddressPlainArgs =
        com.pulumi.azurenative.edgeorder.inputs.GetAddressPlainArgs.builder()
            .addressName(addressName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAddressPlainArgs].
 */
@PulumiTagMarker
public class GetAddressPlainArgsBuilder internal constructor() {
    private var addressName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the address Resource within the specified resource group. address names must be between 3 and 24 characters in length and use any alphanumeric and underscore only.
     */
    @JvmName("axuykcsmumwwycmg")
    public suspend fun addressName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.addressName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gdmypxrdfdsawegy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAddressPlainArgs = GetAddressPlainArgs(
        addressName = addressName ?: throw PulumiNullFieldException("addressName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
