@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Address Properties
 * @property addressValidationStatus Status of address validation
 * @property contactDetails Contact details for the address
 * @property shippingAddress Shipping details for the address
 */
public data class AddressPropertiesResponse(
    public val addressValidationStatus: String,
    public val contactDetails: ContactDetailsResponse,
    public val shippingAddress: ShippingAddressResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.AddressPropertiesResponse): AddressPropertiesResponse = AddressPropertiesResponse(
            addressValidationStatus = javaType.addressValidationStatus(),
            contactDetails = javaType.contactDetails().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.ContactDetailsResponse.Companion.toKotlin(args0)
            }),
            shippingAddress = javaType.shippingAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.ShippingAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
