@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Holds billing meter details for each type of billing.
 * @property frequency Frequency of recurrence.
 * @property meterDetails Represents MeterDetails.
 * @property meteringType Represents Metering type (eg one-time or recurrent).
 * @property name Represents Billing type name.
 */
public data class BillingMeterDetailsResponse(
    public val frequency: String,
    public val meterDetails: Either<Pav2MeterDetailsResponse, PurchaseMeterDetailsResponse>,
    public val meteringType: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.BillingMeterDetailsResponse): BillingMeterDetailsResponse = BillingMeterDetailsResponse(
            frequency = javaType.frequency(),
            meterDetails = javaType.meterDetails().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.edgeorder.kotlin.outputs.Pav2MeterDetailsResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.edgeorder.kotlin.outputs.PurchaseMeterDetailsResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            meteringType = javaType.meteringType(),
            name = javaType.name(),
        )
    }
}
