@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Device details for configuration.
 * @property deviceDetails List of device details.
 * @property displayInfo Display details of the product.
 * @property hierarchyInformation Hierarchy of the product which uniquely identifies the configuration.
 * @property identificationType Identification type of the configuration.
 * @property quantity Quantity of the product.
 */
public data class ConfigurationDeviceDetailsResponse(
    public val deviceDetails: List<DeviceDetailsResponse>,
    public val displayInfo: DisplayInfoResponse? = null,
    public val hierarchyInformation: HierarchyInformationResponse,
    public val identificationType: String,
    public val quantity: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.ConfigurationDeviceDetailsResponse): ConfigurationDeviceDetailsResponse = ConfigurationDeviceDetailsResponse(
            deviceDetails = javaType.deviceDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.DeviceDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            displayInfo = javaType.displayInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.DisplayInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hierarchyInformation = javaType.hierarchyInformation().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.HierarchyInformationResponse.Companion.toKotlin(args0)
            }),
            identificationType = javaType.identificationType(),
            quantity = javaType.quantity(),
        )
    }
}
