@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Description related properties of a product system.
 * @property attributes Attributes for the product system.
 * @property descriptionType Type of description.
 * @property keywords Keywords for the product system.
 * @property links Links for the product system.
 * @property longDescription Long description of the product system.
 * @property shortDescription Short description of the product system.
 */
public data class DescriptionResponse(
    public val attributes: List<String>,
    public val descriptionType: String,
    public val keywords: List<String>,
    public val links: List<LinkResponse>,
    public val longDescription: String,
    public val shortDescription: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.DescriptionResponse): DescriptionResponse = DescriptionResponse(
            attributes = javaType.attributes().map({ args0 -> args0 }),
            descriptionType = javaType.descriptionType(),
            keywords = javaType.keywords().map({ args0 -> args0 }),
            links = javaType.links().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.LinkResponse.Companion.toKotlin(args0)
                })
            }),
            longDescription = javaType.longDescription(),
            shortDescription = javaType.shortDescription(),
        )
    }
}
