@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes product display information
 * @property configurationDisplayName Configuration display name
 * @property productFamilyDisplayName Product family display name
 */
public data class DisplayInfoResponse(
    public val configurationDisplayName: String,
    public val productFamilyDisplayName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.DisplayInfoResponse): DisplayInfoResponse = DisplayInfoResponse(
            configurationDisplayName = javaType.configurationDisplayName(),
            productFamilyDisplayName = javaType.productFamilyDisplayName(),
        )
    }
}
