@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Preferences related to the double encryption
 * @property doubleEncryptionStatus Double encryption status as entered by the customer. It is compulsory to give this parameter if the 'Deny' or 'Disabled' policy is configured.
 */
public data class EncryptionPreferencesResponse(
    public val doubleEncryptionStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.EncryptionPreferencesResponse): EncryptionPreferencesResponse = EncryptionPreferencesResponse(
            doubleEncryptionStatus = javaType.doubleEncryptionStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
