@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Different types of filters supported and its values.
 * @property supportedValues Values to be filtered.
 * @property type Type of product filter.
 */
public data class FilterablePropertyResponse(
    public val supportedValues: List<String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.FilterablePropertyResponse): FilterablePropertyResponse = FilterablePropertyResponse(
            supportedValues = javaType.supportedValues().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
