@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents order item resource.
 * @property addressDetails Represents shipping and return address for order item.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property orderId Id of the order to which order item belongs to.
 * @property orderItemDetails Represents order item details.
 * @property startTime Start time of order item.
 * @property systemData Represents resource creation and update time.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetOrderItemResult(
    public val addressDetails: AddressDetailsResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val orderId: String,
    public val orderItemDetails: OrderItemDetailsResponse,
    public val startTime: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.GetOrderItemResult): GetOrderItemResult = GetOrderItemResult(
            addressDetails = javaType.addressDetails().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.AddressDetailsResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            orderId = javaType.orderId(),
            orderItemDetails = javaType.orderItemDetails().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.OrderItemDetailsResponse.Companion.toKotlin(args0)
            }),
            startTime = javaType.startTime(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
