@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Holds details about product hierarchy information.
 * @property configurationName Represents configuration name that uniquely identifies configuration.
 * @property productFamilyName Represents product family name that uniquely identifies product family.
 * @property productLineName Represents product line name that uniquely identifies product line.
 * @property productName Represents product name that uniquely identifies product.
 */
public data class HierarchyInformationResponse(
    public val configurationName: String? = null,
    public val productFamilyName: String? = null,
    public val productLineName: String? = null,
    public val productName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.HierarchyInformationResponse): HierarchyInformationResponse = HierarchyInformationResponse(
            configurationName = javaType.configurationName().map({ args0 -> args0 }).orElse(null),
            productFamilyName = javaType.productFamilyName().map({ args0 -> args0 }).orElse(null),
            productLineName = javaType.productLineName().map({ args0 -> args0 }).orElse(null),
            productName = javaType.productName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
