@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Image for the product.
 * @property imageType Type of the image.
 * @property imageUrl Url of the image.
 */
public data class ImageInformationResponse(
    public val imageType: String,
    public val imageUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.ImageInformationResponse): ImageInformationResponse = ImageInformationResponse(
            imageType = javaType.imageType(),
            imageUrl = javaType.imageUrl(),
        )
    }
}
