@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Order item details
 * @property cancellationReason Cancellation reason.
 * @property cancellationStatus Describes whether the order item is cancellable or not.
 * @property currentStage Current Order item Status
 * @property deletionStatus Describes whether the order item is deletable or not.
 * @property error Top level error for the job.
 * @property forwardShippingDetails Forward Package Shipping details
 * @property managementRpDetails Parent RP details - this returns only the first or default parent RP from the entire list
 * @property managementRpDetailsList List of parent RP details supported for configuration.
 * @property notificationEmailList Additional notification email list
 * @property orderItemMode Defines the mode of the Order item.
 * @property orderItemStageHistory Order item status history
 * @property orderItemType Order item type.
 * @property preferences Customer notification Preferences
 * @property productDetails Unique identifier for configuration.
 * @property returnReason Return reason.
 * @property returnStatus Describes whether the order item is returnable or not.
 * @property reverseShippingDetails Reverse Package Shipping details
 */
public data class OrderItemDetailsResponse(
    public val cancellationReason: String,
    public val cancellationStatus: String,
    public val currentStage: StageDetailsResponse,
    public val deletionStatus: String,
    public val error: ErrorDetailResponse,
    public val forwardShippingDetails: ForwardShippingDetailsResponse,
    public val managementRpDetails: ResourceProviderDetailsResponse,
    public val managementRpDetailsList: List<ResourceProviderDetailsResponse>,
    public val notificationEmailList: List<String>? = null,
    public val orderItemMode: String? = null,
    public val orderItemStageHistory: List<StageDetailsResponse>,
    public val orderItemType: String,
    public val preferences: PreferencesResponse? = null,
    public val productDetails: ProductDetailsResponse,
    public val returnReason: String,
    public val returnStatus: String,
    public val reverseShippingDetails: ReverseShippingDetailsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.OrderItemDetailsResponse): OrderItemDetailsResponse = OrderItemDetailsResponse(
            cancellationReason = javaType.cancellationReason(),
            cancellationStatus = javaType.cancellationStatus(),
            currentStage = javaType.currentStage().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.StageDetailsResponse.Companion.toKotlin(args0)
            }),
            deletionStatus = javaType.deletionStatus(),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
            }),
            forwardShippingDetails = javaType.forwardShippingDetails().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.ForwardShippingDetailsResponse.Companion.toKotlin(args0)
            }),
            managementRpDetails = javaType.managementRpDetails().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.ResourceProviderDetailsResponse.Companion.toKotlin(args0)
            }),
            managementRpDetailsList = javaType.managementRpDetailsList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.ResourceProviderDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            notificationEmailList = javaType.notificationEmailList().map({ args0 -> args0 }),
            orderItemMode = javaType.orderItemMode().map({ args0 -> args0 }).orElse(null),
            orderItemStageHistory = javaType.orderItemStageHistory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.StageDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            orderItemType = javaType.orderItemType(),
            preferences = javaType.preferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.PreferencesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            productDetails = javaType.productDetails().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.ProductDetailsResponse.Companion.toKotlin(args0)
            }),
            returnReason = javaType.returnReason(),
            returnStatus = javaType.returnStatus(),
            reverseShippingDetails = javaType.reverseShippingDetails().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.ReverseShippingDetailsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
