@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents product details
 * @property childConfigurationDeviceDetails Details of all child configurations that are part of the order item.
 * @property count Quantity of the product
 * @property deviceDetails list of device details
 * @property displayInfo Display details of the product
 * @property hierarchyInformation Hierarchy of the product which uniquely identifies the product
 * @property identificationType Identification type of the configuration.
 * @property optInAdditionalConfigurations List of additional configurations customer wants in the order item apart from the ones included in the base configuration.
 * @property parentDeviceDetails Device details of the parent configuration.
 * @property productDoubleEncryptionStatus Double encryption status of the configuration. Read-only field.
 */
public data class ProductDetailsResponse(
    public val childConfigurationDeviceDetails: List<ConfigurationDeviceDetailsResponse>? = null,
    public val count: Int,
    public val deviceDetails: List<DeviceDetailsResponse>,
    public val displayInfo: DisplayInfoResponse? = null,
    public val hierarchyInformation: HierarchyInformationResponse,
    public val identificationType: String? = null,
    public val optInAdditionalConfigurations: List<AdditionalConfigurationResponse>? = null,
    public val parentDeviceDetails: DeviceDetailsResponse? = null,
    public val productDoubleEncryptionStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.ProductDetailsResponse): ProductDetailsResponse = ProductDetailsResponse(
            childConfigurationDeviceDetails = javaType.childConfigurationDeviceDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.ConfigurationDeviceDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            count = javaType.count(),
            deviceDetails = javaType.deviceDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.DeviceDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            displayInfo = javaType.displayInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.DisplayInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hierarchyInformation = javaType.hierarchyInformation().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.HierarchyInformationResponse.Companion.toKotlin(args0)
            }),
            identificationType = javaType.identificationType().map({ args0 -> args0 }).orElse(null),
            optInAdditionalConfigurations = javaType.optInAdditionalConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.AdditionalConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            parentDeviceDetails = javaType.parentDeviceDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.DeviceDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            productDoubleEncryptionStatus = javaType.productDoubleEncryptionStatus(),
        )
    }
}
