@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Reverse shipment details.
 * @property carrierDisplayName Carrier Name for display purpose. Not to be used for any processing.
 * @property carrierName Name of the carrier.
 * @property sasKeyForLabel SAS key to download the reverse shipment label of the package.
 * @property trackingId TrackingId of the package
 * @property trackingUrl TrackingUrl of the package.
 */
public data class ReverseShippingDetailsResponse(
    public val carrierDisplayName: String,
    public val carrierName: String,
    public val sasKeyForLabel: String,
    public val trackingId: String,
    public val trackingUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.ReverseShippingDetailsResponse): ReverseShippingDetailsResponse = ReverseShippingDetailsResponse(
            carrierDisplayName = javaType.carrierDisplayName(),
            carrierName = javaType.carrierName(),
            sasKeyForLabel = javaType.sasKeyForLabel(),
            trackingId = javaType.trackingId(),
            trackingUrl = javaType.trackingUrl(),
        )
    }
}
