@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Preferences related to the shipment logistics of the sku
 * @property preferredShipmentType Indicates Shipment Logistics type that the customer preferred.
 */
public data class TransportPreferencesResponse(
    public val preferredShipmentType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.TransportPreferencesResponse): TransportPreferencesResponse = TransportPreferencesResponse(
            preferredShipmentType = javaType.preferredShipmentType(),
        )
    }
}
