@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.education.kotlin

import com.pulumi.azurenative.education.kotlin.outputs.AmountResponse
import com.pulumi.azurenative.education.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.education.kotlin.outputs.AmountResponse.Companion.toKotlin as amountResponseToKotlin
import com.pulumi.azurenative.education.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Lab].
 */
@PulumiTagMarker
public class LabResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LabArgs = LabArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LabArgsBuilder.() -> Unit) {
        val builder = LabArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Lab {
        val builtJavaResource = com.pulumi.azurenative.education.Lab(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Lab(builtJavaResource)
    }
}

/**
 * Lab details.
 * Azure REST API version: 2021-12-01-preview. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * ## Example Usage
 * ### CreateLab
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lab = new AzureNative.Education.Lab("lab", new()
 *     {
 *         BillingAccountName = "{billingAccountName}",
 *         BillingProfileName = "{billingProfileName}",
 *         BudgetPerStudent = new AzureNative.Education.Inputs.AmountArgs
 *         {
 *             Currency = "USD",
 *             Value = 100,
 *         },
 *         Description = "example lab description",
 *         DisplayName = "example lab",
 *         ExpirationDate = "2021-12-09T22:11:29.422Z",
 *         InvoiceSectionName = "{invoiceSectionName}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/education/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := education.NewLab(ctx, "lab", &education.LabArgs{
 * 			BillingAccountName: pulumi.String("{billingAccountName}"),
 * 			BillingProfileName: pulumi.String("{billingProfileName}"),
 * 			BudgetPerStudent: &education.AmountArgs{
 * 				Currency: pulumi.String("USD"),
 * 				Value:    pulumi.Float64(100),
 * 			},
 * 			Description:        pulumi.String("example lab description"),
 * 			DisplayName:        pulumi.String("example lab"),
 * 			ExpirationDate:     pulumi.String("2021-12-09T22:11:29.422Z"),
 * 			InvoiceSectionName: pulumi.String("{invoiceSectionName}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.education.Lab;
 * import com.pulumi.azurenative.education.LabArgs;
 * import com.pulumi.azurenative.education.inputs.AmountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lab = new Lab("lab", LabArgs.builder()
 *             .billingAccountName("{billingAccountName}")
 *             .billingProfileName("{billingProfileName}")
 *             .budgetPerStudent(AmountArgs.builder()
 *                 .currency("USD")
 *                 .value(100)
 *                 .build())
 *             .description("example lab description")
 *             .displayName("example lab")
 *             .expirationDate("2021-12-09T22:11:29.422Z")
 *             .invoiceSectionName("{invoiceSectionName}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:education:Lab default /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default
 * ```
 */
public class Lab internal constructor(
    override val javaResource: com.pulumi.azurenative.education.Lab,
) : KotlinCustomResource(javaResource, LabMapper) {
    /**
     * Default monetary cap for each student in this lab
     */
    public val budgetPerStudent: Output<AmountResponse>
        get() = javaResource.budgetPerStudent().applyValue({ args0 ->
            args0.let({ args0 ->
                amountResponseToKotlin(args0)
            })
        })

    /**
     * The type of currency being used for the value.
     */
    public val currency: Output<String>?
        get() = javaResource.currency().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Detail description of this lab
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Lab Display Name
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Lab creation date
     */
    public val effectiveDate: Output<String>
        get() = javaResource.effectiveDate().applyValue({ args0 -> args0 })

    /**
     * Default expiration date for each student in this lab
     */
    public val expirationDate: Output<String>
        get() = javaResource.expirationDate().applyValue({ args0 -> args0 })

    /**
     * invitation code for redeemable lab
     */
    public val invitationCode: Output<String>
        get() = javaResource.invitationCode().applyValue({ args0 -> args0 })

    /**
     * the total number of students that can be accepted to the lab.
     */
    public val maxStudentCount: Output<Double>
        get() = javaResource.maxStudentCount().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of this lab
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Amount value.
     */
    public val `value`: Output<Double>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object LabMapper : ResourceMapper<Lab> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.education.Lab::class == javaResource::class

    override fun map(javaResource: Resource): Lab = Lab(
        javaResource as
            com.pulumi.azurenative.education.Lab,
    )
}

/**
 * @see [Lab].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Lab].
 */
public suspend fun lab(name: String, block: suspend LabResourceBuilder.() -> Unit): Lab {
    val builder = LabResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Lab].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lab(name: String): Lab {
    val builder = LabResourceBuilder()
    builder.name(name)
    return builder.build()
}
