@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.education.kotlin

import com.pulumi.azurenative.education.kotlin.outputs.AmountResponse
import com.pulumi.azurenative.education.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.education.kotlin.outputs.AmountResponse.Companion.toKotlin as amountResponseToKotlin
import com.pulumi.azurenative.education.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Student].
 */
@PulumiTagMarker
public class StudentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StudentArgs = StudentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StudentArgsBuilder.() -> Unit) {
        val builder = StudentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Student {
        val builtJavaResource = com.pulumi.azurenative.education.Student(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Student(builtJavaResource)
    }
}

/**
 * Student details.
 * Azure REST API version: 2021-12-01-preview. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * ## Example Usage
 * ### Student
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var student = new AzureNative.Education.Student("student", new()
 *     {
 *         BillingAccountName = "{billingAccountName}",
 *         BillingProfileName = "{billingProfileName}",
 *         Budget = new AzureNative.Education.Inputs.AmountArgs
 *         {
 *             Currency = "USD",
 *             Value = 100,
 *         },
 *         Email = "test@contoso.com",
 *         ExpirationDate = "2021-11-09T22:13:21.795Z",
 *         FirstName = "test",
 *         InvoiceSectionName = "{invoiceSectionName}",
 *         LastName = "user",
 *         Role = AzureNative.Education.StudentRole.Student,
 *         StudentAlias = "{studentAlias}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/education/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := education.NewStudent(ctx, "student", &education.StudentArgs{
 * 			BillingAccountName: pulumi.String("{billingAccountName}"),
 * 			BillingProfileName: pulumi.String("{billingProfileName}"),
 * 			Budget: &education.AmountArgs{
 * 				Currency: pulumi.String("USD"),
 * 				Value:    pulumi.Float64(100),
 * 			},
 * 			Email:              pulumi.String("test@contoso.com"),
 * 			ExpirationDate:     pulumi.String("2021-11-09T22:13:21.795Z"),
 * 			FirstName:          pulumi.String("test"),
 * 			InvoiceSectionName: pulumi.String("{invoiceSectionName}"),
 * 			LastName:           pulumi.String("user"),
 * 			Role:               pulumi.String(education.StudentRoleStudent),
 * 			StudentAlias:       pulumi.String("{studentAlias}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.education.Student;
 * import com.pulumi.azurenative.education.StudentArgs;
 * import com.pulumi.azurenative.education.inputs.AmountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var student = new Student("student", StudentArgs.builder()
 *             .billingAccountName("{billingAccountName}")
 *             .billingProfileName("{billingProfileName}")
 *             .budget(AmountArgs.builder()
 *                 .currency("USD")
 *                 .value(100)
 *                 .build())
 *             .email("test@contoso.com")
 *             .expirationDate("2021-11-09T22:13:21.795Z")
 *             .firstName("test")
 *             .invoiceSectionName("{invoiceSectionName}")
 *             .lastName("user")
 *             .role("Student")
 *             .studentAlias("{studentAlias}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:education:Student {studentAlias} /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default/students/{studentAlias}
 * ```
 */
public class Student internal constructor(
    override val javaResource: com.pulumi.azurenative.education.Student,
) : KotlinCustomResource(javaResource, StudentMapper) {
    /**
     * Student Budget
     */
    public val budget: Output<AmountResponse>
        get() = javaResource.budget().applyValue({ args0 ->
            args0.let({ args0 ->
                amountResponseToKotlin(args0)
            })
        })

    /**
     * Date student was added to the lab
     */
    public val effectiveDate: Output<String>
        get() = javaResource.effectiveDate().applyValue({ args0 -> args0 })

    /**
     * Student Email
     */
    public val email: Output<String>
        get() = javaResource.email().applyValue({ args0 -> args0 })

    /**
     * Date this student is set to expire from the lab.
     */
    public val expirationDate: Output<String>
        get() = javaResource.expirationDate().applyValue({ args0 -> args0 })

    /**
     * First Name
     */
    public val firstName: Output<String>
        get() = javaResource.firstName().applyValue({ args0 -> args0 })

    /**
     * Last Name
     */
    public val lastName: Output<String>
        get() = javaResource.lastName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Student Role
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * Student Lab Status
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Subscription alias
     */
    public val subscriptionAlias: Output<String>?
        get() = javaResource.subscriptionAlias().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subscription Id
     */
    public val subscriptionId: Output<String>
        get() = javaResource.subscriptionId().applyValue({ args0 -> args0 })

    /**
     * subscription invite last sent date
     */
    public val subscriptionInviteLastSentDate: Output<String>?
        get() = javaResource.subscriptionInviteLastSentDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StudentMapper : ResourceMapper<Student> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.education.Student::class == javaResource::class

    override fun map(javaResource: Resource): Student = Student(
        javaResource as
            com.pulumi.azurenative.education.Student,
    )
}

/**
 * @see [Student].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Student].
 */
public suspend fun student(name: String, block: suspend StudentResourceBuilder.() -> Unit): Student {
    val builder = StudentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Student].
 * @param name The _unique_ name of the resulting resource.
 */
public fun student(name: String): Student {
    val builder = StudentResourceBuilder()
    builder.name(name)
    return builder.build()
}
