@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.education.kotlin.inputs

import com.pulumi.azurenative.education.inputs.GetStudentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property billingAccountName The ID that uniquely identifies a billing account.
 * @property billingProfileName The ID that uniquely identifies a billing profile.
 * @property invoiceSectionName The ID that uniquely identifies an invoice section.
 * @property studentAlias Student alias.
 */
public data class GetStudentPlainArgs(
    public val billingAccountName: String,
    public val billingProfileName: String,
    public val invoiceSectionName: String,
    public val studentAlias: String,
) : ConvertibleToJava<com.pulumi.azurenative.education.inputs.GetStudentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.education.inputs.GetStudentPlainArgs =
        com.pulumi.azurenative.education.inputs.GetStudentPlainArgs.builder()
            .billingAccountName(billingAccountName.let({ args0 -> args0 }))
            .billingProfileName(billingProfileName.let({ args0 -> args0 }))
            .invoiceSectionName(invoiceSectionName.let({ args0 -> args0 }))
            .studentAlias(studentAlias.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStudentPlainArgs].
 */
@PulumiTagMarker
public class GetStudentPlainArgsBuilder internal constructor() {
    private var billingAccountName: String? = null

    private var billingProfileName: String? = null

    private var invoiceSectionName: String? = null

    private var studentAlias: String? = null

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("bdjrhxcelbxdpqhy")
    public suspend fun billingAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingAccountName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a billing profile.
     */
    @JvmName("ljdbwmskjxgyuqiw")
    public suspend fun billingProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingProfileName = mapped
    }

    /**
     * @param value The ID that uniquely identifies an invoice section.
     */
    @JvmName("vwdybhplmgcuohui")
    public suspend fun invoiceSectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.invoiceSectionName = mapped
    }

    /**
     * @param value Student alias.
     */
    @JvmName("tbtyhdjehwnsmrcj")
    public suspend fun studentAlias(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.studentAlias = mapped
    }

    internal fun build(): GetStudentPlainArgs = GetStudentPlainArgs(
        billingAccountName = billingAccountName ?: throw PulumiNullFieldException("billingAccountName"),
        billingProfileName = billingProfileName ?: throw PulumiNullFieldException("billingProfileName"),
        invoiceSectionName = invoiceSectionName ?: throw PulumiNullFieldException("invoiceSectionName"),
        studentAlias = studentAlias ?: throw PulumiNullFieldException("studentAlias"),
    )
}
