@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.education.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Student details.
 * @property budget Student Budget
 * @property effectiveDate Date student was added to the lab
 * @property email Student Email
 * @property expirationDate Date this student is set to expire from the lab.
 * @property firstName First Name
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastName Last Name
 * @property name The name of the resource
 * @property role Student Role
 * @property status Student Lab Status
 * @property subscriptionAlias Subscription alias
 * @property subscriptionId Subscription Id
 * @property subscriptionInviteLastSentDate subscription invite last sent date
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetStudentResult(
    public val budget: AmountResponse,
    public val effectiveDate: String,
    public val email: String,
    public val expirationDate: String,
    public val firstName: String,
    public val id: String,
    public val lastName: String,
    public val name: String,
    public val role: String,
    public val status: String,
    public val subscriptionAlias: String? = null,
    public val subscriptionId: String,
    public val subscriptionInviteLastSentDate: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.education.outputs.GetStudentResult): GetStudentResult = GetStudentResult(
            budget = javaType.budget().let({ args0 ->
                com.pulumi.azurenative.education.kotlin.outputs.AmountResponse.Companion.toKotlin(args0)
            }),
            effectiveDate = javaType.effectiveDate(),
            email = javaType.email(),
            expirationDate = javaType.expirationDate(),
            firstName = javaType.firstName(),
            id = javaType.id(),
            lastName = javaType.lastName(),
            name = javaType.name(),
            role = javaType.role(),
            status = javaType.status(),
            subscriptionAlias = javaType.subscriptionAlias().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId(),
            subscriptionInviteLastSentDate = javaType.subscriptionInviteLastSentDate().map({ args0 ->
                args0
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.education.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
