@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin

import com.pulumi.azurenative.elastic.MonitorArgs.builder
import com.pulumi.azurenative.elastic.kotlin.inputs.IdentityPropertiesArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.IdentityPropertiesArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.MonitorPropertiesArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.MonitorPropertiesArgsBuilder
import com.pulumi.azurenative.elastic.kotlin.inputs.ResourceSkuArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.ResourceSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Monitor resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview, 2023-11-01-preview, 2024-01-01-preview, 2024-03-01, 2024-05-01-preview.
 * ## Example Usage
 * ### Monitors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitor = new AzureNative.Elastic.Monitor("monitor", new()
 *     {
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elastic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elastic.NewMonitor(ctx, "monitor", &elastic.MonitorArgs{
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elastic.Monitor;
 * import com.pulumi.azurenative.elastic.MonitorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitor = new Monitor("monitor", MonitorArgs.builder()
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elastic:Monitor myMonitor /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}
 * ```
 * @property identity Identity properties of the monitor resource.
 * @property location The location of the monitor resource
 * @property monitorName Monitor resource name
 * @property properties Properties of the monitor resource.
 * @property resourceGroupName The name of the resource group to which the Elastic resource belongs.
 * @property sku SKU of the monitor resource.
 * @property tags The tags of the monitor resource.
 */
public data class MonitorArgs(
    public val identity: Output<IdentityPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val monitorName: Output<String>? = null,
    public val properties: Output<MonitorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ResourceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.MonitorArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.MonitorArgs =
        com.pulumi.azurenative.elastic.MonitorArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MonitorArgs].
 */
@PulumiTagMarker
public class MonitorArgsBuilder internal constructor() {
    private var identity: Output<IdentityPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var monitorName: Output<String>? = null

    private var properties: Output<MonitorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ResourceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Identity properties of the monitor resource.
     */
    @JvmName("spefixkumlkowifu")
    public suspend fun identity(`value`: Output<IdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value The location of the monitor resource
     */
    @JvmName("anlaqmnmpvboldqg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("wgmabnnsesycruof")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value Properties of the monitor resource.
     */
    @JvmName("pmwgwlqrxbuivyto")
    public suspend fun properties(`value`: Output<MonitorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group to which the Elastic resource belongs.
     */
    @JvmName("fachewidukvvydap")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SKU of the monitor resource.
     */
    @JvmName("unsernhedtwomeap")
    public suspend fun sku(`value`: Output<ResourceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The tags of the monitor resource.
     */
    @JvmName("sjekvhtfqmbfhxuh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Identity properties of the monitor resource.
     */
    @JvmName("olwyoxsdcpbiqmal")
    public suspend fun identity(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity properties of the monitor resource.
     */
    @JvmName("lsdbratgxhxofxen")
    public suspend fun identity(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The location of the monitor resource
     */
    @JvmName("potogqgnthxofjki")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("vbfsyvnospujnggx")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value Properties of the monitor resource.
     */
    @JvmName("urlavlrgxqpremga")
    public suspend fun properties(`value`: MonitorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the monitor resource.
     */
    @JvmName("qgknhunymoslqhae")
    public suspend fun properties(argument: suspend MonitorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MonitorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group to which the Elastic resource belongs.
     */
    @JvmName("omubgjoskwredwhm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SKU of the monitor resource.
     */
    @JvmName("irhiwbjkyiseaqgf")
    public suspend fun sku(`value`: ResourceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU of the monitor resource.
     */
    @JvmName("poraocgnsjydpaqy")
    public suspend fun sku(argument: suspend ResourceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The tags of the monitor resource.
     */
    @JvmName("usmmhkvrvtcumbvx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the monitor resource.
     */
    @JvmName("gifgsmtuvuksrjka")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MonitorArgs = MonitorArgs(
        identity = identity,
        location = location,
        monitorName = monitorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
