@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin

import com.pulumi.azurenative.elastic.MonitoredSubscriptionArgs.builder
import com.pulumi.azurenative.elastic.kotlin.inputs.SubscriptionListArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.SubscriptionListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The request to update subscriptions needed to be monitored by the Elastic monitor resource.
 * Azure REST API version: 2024-05-01-preview.
 * ## Example Usage
 * ### Monitors_AddMonitoredSubscriptions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitoredSubscription = new AzureNative.Elastic.MonitoredSubscription("monitoredSubscription", new()
 *     {
 *         ConfigurationName = "default",
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elastic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elastic.NewMonitoredSubscription(ctx, "monitoredSubscription", &elastic.MonitoredSubscriptionArgs{
 * 			ConfigurationName: pulumi.String("default"),
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elastic.MonitoredSubscription;
 * import com.pulumi.azurenative.elastic.MonitoredSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitoredSubscription = new MonitoredSubscription("monitoredSubscription", MonitoredSubscriptionArgs.builder()
 *             .configurationName("default")
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elastic:MonitoredSubscription default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/monitoredSubscriptions/{configurationName}
 * ```
 * @property configurationName The configuration name. Only 'default' value is supported.
 * @property monitorName Monitor resource name
 * @property properties The request to update subscriptions needed to be monitored by the Elastic monitor resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class MonitoredSubscriptionArgs(
    public val configurationName: Output<String>? = null,
    public val monitorName: Output<String>? = null,
    public val properties: Output<SubscriptionListArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.MonitoredSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.MonitoredSubscriptionArgs =
        com.pulumi.azurenative.elastic.MonitoredSubscriptionArgs.builder()
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitoredSubscriptionArgs].
 */
@PulumiTagMarker
public class MonitoredSubscriptionArgsBuilder internal constructor() {
    private var configurationName: Output<String>? = null

    private var monitorName: Output<String>? = null

    private var properties: Output<SubscriptionListArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The configuration name. Only 'default' value is supported.
     */
    @JvmName("ifigtuuptvklskwm")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("wbbexwbgtfgisdgu")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value The request to update subscriptions needed to be monitored by the Elastic monitor resource.
     */
    @JvmName("gcpuntsofyuhmgao")
    public suspend fun properties(`value`: Output<SubscriptionListArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("raviljcmuoosvvkm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The configuration name. Only 'default' value is supported.
     */
    @JvmName("wversrmvdqjuayda")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("buywmxbunityxpsi")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value The request to update subscriptions needed to be monitored by the Elastic monitor resource.
     */
    @JvmName("vpnifmhjewowleaj")
    public suspend fun properties(`value`: SubscriptionListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The request to update subscriptions needed to be monitored by the Elastic monitor resource.
     */
    @JvmName("fmjoknyktyljcdfj")
    public suspend fun properties(argument: suspend SubscriptionListArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriptionListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kyrgqkgycvwcuddn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): MonitoredSubscriptionArgs = MonitoredSubscriptionArgs(
        configurationName = configurationName,
        monitorName = monitorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
