@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin

import com.pulumi.azurenative.elastic.OpenAIArgs.builder
import com.pulumi.azurenative.elastic.kotlin.inputs.OpenAIIntegrationPropertiesArgs
import com.pulumi.azurenative.elastic.kotlin.inputs.OpenAIIntegrationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Capture properties of Open AI resource Integration.
 * Azure REST API version: 2024-03-01.
 * Other available API versions: 2024-01-01-preview, 2024-05-01-preview.
 * ## Example Usage
 * ### OpenAI_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var openAI = new AzureNative.Elastic.OpenAI("openAI", new()
 *     {
 *         IntegrationName = "default",
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elastic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elastic.NewOpenAI(ctx, "openAI", &elastic.OpenAIArgs{
 * 			IntegrationName:   pulumi.String("default"),
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elastic.OpenAI;
 * import com.pulumi.azurenative.elastic.OpenAIArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var openAI = new OpenAI("openAI", OpenAIArgs.builder()
 *             .integrationName("default")
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elastic:OpenAI default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations/{integrationName}
 * ```
 * @property integrationName OpenAI Integration name
 * @property monitorName Monitor resource name
 * @property properties Open AI Integration details.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class OpenAIArgs(
    public val integrationName: Output<String>? = null,
    public val monitorName: Output<String>? = null,
    public val properties: Output<OpenAIIntegrationPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.OpenAIArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.OpenAIArgs =
        com.pulumi.azurenative.elastic.OpenAIArgs.builder()
            .integrationName(integrationName?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenAIArgs].
 */
@PulumiTagMarker
public class OpenAIArgsBuilder internal constructor() {
    private var integrationName: Output<String>? = null

    private var monitorName: Output<String>? = null

    private var properties: Output<OpenAIIntegrationPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value OpenAI Integration name
     */
    @JvmName("penbqcomjyfufecg")
    public suspend fun integrationName(`value`: Output<String>) {
        this.integrationName = value
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("ukaghwqrwywiiyhs")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value Open AI Integration details.
     */
    @JvmName("slmtwlxymdtvlwkv")
    public suspend fun properties(`value`: Output<OpenAIIntegrationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ymesfxurycjffxfx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value OpenAI Integration name
     */
    @JvmName("iarpiaudxtigipwm")
    public suspend fun integrationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationName = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("xkraxueiliqctucn")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value Open AI Integration details.
     */
    @JvmName("fdnytlxaahiordqi")
    public suspend fun properties(`value`: OpenAIIntegrationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Open AI Integration details.
     */
    @JvmName("llwjxpiogcmjpewx")
    public suspend fun properties(argument: suspend OpenAIIntegrationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = OpenAIIntegrationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vdpgnkkwvdjuhhve")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): OpenAIArgs = OpenAIArgs(
        integrationName = integrationName,
        monitorName = monitorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
