@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.OpenAIIntegrationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Open AI Integration details.
 * @property key Value of API key for Open AI resource
 * @property openAIResourceEndpoint The API endpoint for Open AI resource
 * @property openAIResourceId The resource id of Open AI resource
 */
public data class OpenAIIntegrationPropertiesArgs(
    public val key: Output<String>? = null,
    public val openAIResourceEndpoint: Output<String>? = null,
    public val openAIResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.OpenAIIntegrationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.OpenAIIntegrationPropertiesArgs =
        com.pulumi.azurenative.elastic.inputs.OpenAIIntegrationPropertiesArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .openAIResourceEndpoint(openAIResourceEndpoint?.applyValue({ args0 -> args0 }))
            .openAIResourceId(openAIResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenAIIntegrationPropertiesArgs].
 */
@PulumiTagMarker
public class OpenAIIntegrationPropertiesArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var openAIResourceEndpoint: Output<String>? = null

    private var openAIResourceId: Output<String>? = null

    /**
     * @param value Value of API key for Open AI resource
     */
    @JvmName("hytfrkvigmodgkfu")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The API endpoint for Open AI resource
     */
    @JvmName("kxqrjjuahbtidqxk")
    public suspend fun openAIResourceEndpoint(`value`: Output<String>) {
        this.openAIResourceEndpoint = value
    }

    /**
     * @param value The resource id of Open AI resource
     */
    @JvmName("ekeluxqanjhcxxvj")
    public suspend fun openAIResourceId(`value`: Output<String>) {
        this.openAIResourceId = value
    }

    /**
     * @param value Value of API key for Open AI resource
     */
    @JvmName("hoogntxgaxnycokp")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The API endpoint for Open AI resource
     */
    @JvmName("jxwxuerytwfsvvhm")
    public suspend fun openAIResourceEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openAIResourceEndpoint = mapped
    }

    /**
     * @param value The resource id of Open AI resource
     */
    @JvmName("cbwlujocdtnuvdcu")
    public suspend fun openAIResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openAIResourceId = mapped
    }

    internal fun build(): OpenAIIntegrationPropertiesArgs = OpenAIIntegrationPropertiesArgs(
        key = key,
        openAIResourceEndpoint = openAIResourceEndpoint,
        openAIResourceId = openAIResourceId,
    )
}
