@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connected Partner Resource Properties
 * @property azureResourceId The azure resource Id of the deployment.
 * @property location The location of the deployment.
 * @property partnerDeploymentName Elastic deployment name
 * @property partnerDeploymentUri Deployment URL of the elasticsearch in Elastic cloud deployment.
 */
public data class ConnectedPartnerResourcePropertiesResponse(
    public val azureResourceId: String? = null,
    public val location: String? = null,
    public val partnerDeploymentName: String? = null,
    public val partnerDeploymentUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ConnectedPartnerResourcePropertiesResponse): ConnectedPartnerResourcePropertiesResponse = ConnectedPartnerResourcePropertiesResponse(
            azureResourceId = javaType.azureResourceId().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            partnerDeploymentName = javaType.partnerDeploymentName().map({ args0 -> args0 }).orElse(null),
            partnerDeploymentUri = javaType.partnerDeploymentUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
