@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the user's elastic deployment associated with the monitor resource.
 * @property azureSubscriptionId Associated Azure subscription Id for the elastic deployment.
 * @property deploymentId Elastic deployment Id
 * @property elasticsearchRegion Region where Deployment at Elastic side took place.
 * @property elasticsearchServiceUrl Elasticsearch ingestion endpoint of the Elastic deployment.
 * @property kibanaServiceUrl Kibana endpoint of the Elastic deployment.
 * @property kibanaSsoUrl Kibana dashboard sso URL of the Elastic deployment.
 * @property name Elastic deployment name
 */
public data class ElasticCloudDeploymentResponse(
    public val azureSubscriptionId: String,
    public val deploymentId: String,
    public val elasticsearchRegion: String,
    public val elasticsearchServiceUrl: String,
    public val kibanaServiceUrl: String,
    public val kibanaSsoUrl: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ElasticCloudDeploymentResponse): ElasticCloudDeploymentResponse = ElasticCloudDeploymentResponse(
            azureSubscriptionId = javaType.azureSubscriptionId(),
            deploymentId = javaType.deploymentId(),
            elasticsearchRegion = javaType.elasticsearchRegion(),
            elasticsearchServiceUrl = javaType.elasticsearchServiceUrl(),
            kibanaServiceUrl = javaType.kibanaServiceUrl(),
            kibanaSsoUrl = javaType.kibanaSsoUrl(),
            name = javaType.name(),
        )
    }
}
