@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the user's elastic account.
 * @property elasticCloudSsoDefaultUrl Elastic cloud default dashboard sso URL of the Elastic user account.
 * @property emailAddress Email of the Elastic User Account.
 * @property id User Id of the elastic account of the User.
 */
public data class ElasticCloudUserResponse(
    public val elasticCloudSsoDefaultUrl: String,
    public val emailAddress: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ElasticCloudUserResponse): ElasticCloudUserResponse = ElasticCloudUserResponse(
            elasticCloudSsoDefaultUrl = javaType.elasticCloudSsoDefaultUrl(),
            emailAddress = javaType.emailAddress(),
            id = javaType.id(),
        )
    }
}
