@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of Azure Subscription ID to which the Organization of the logged in user belongs and gets billed into.
 * @property billedAzureSubscriptionId The Azure Subscription ID to which the Organization belongs and gets billed into. This is empty for a new user OR a user without an Elastic Organization.
 * @property elasticOrganizationId The Elastic Organization Id.
 * @property elasticOrganizationName The Elastic Organization Name.
 * @property marketplaceSaasInfo Marketplace SaaS Info of the resource.
 */
public data class ElasticOrganizationToAzureSubscriptionMappingResponsePropertiesResponse(
    public val billedAzureSubscriptionId: String? = null,
    public val elasticOrganizationId: String? = null,
    public val elasticOrganizationName: String? = null,
    public val marketplaceSaasInfo: MarketplaceSaaSInfoResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ElasticOrganizationToAzureSubscriptionMappingResponsePropertiesResponse): ElasticOrganizationToAzureSubscriptionMappingResponsePropertiesResponse =
            ElasticOrganizationToAzureSubscriptionMappingResponsePropertiesResponse(
                billedAzureSubscriptionId = javaType.billedAzureSubscriptionId().map({ args0 ->
                    args0
                }).orElse(null),
                elasticOrganizationId = javaType.elasticOrganizationId().map({ args0 -> args0 }).orElse(null),
                elasticOrganizationName = javaType.elasticOrganizationName().map({ args0 -> args0 }).orElse(null),
                marketplaceSaasInfo = javaType.marketplaceSaasInfo().let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.MarketplaceSaaSInfoResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
