@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.Suppress

/**
 * Elastic Resource Properties.
 * @property elasticCloudDeployment Details of the elastic cloud deployment.
 * @property elasticCloudUser Details of the user's elastic account.
 */
public data class ElasticPropertiesResponse(
    public val elasticCloudDeployment: ElasticCloudDeploymentResponse? = null,
    public val elasticCloudUser: ElasticCloudUserResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ElasticPropertiesResponse): ElasticPropertiesResponse = ElasticPropertiesResponse(
            elasticCloudDeployment = javaType.elasticCloudDeployment().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.ElasticCloudDeploymentResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            elasticCloudUser = javaType.elasticCloudUser().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.ElasticCloudUserResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
