@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Elastic traffic filter rule object
 * @property azureEndpointGuid Guid of Private Endpoint in the elastic filter rule
 * @property azureEndpointName Name of the Private Endpoint in the elastic filter rule
 * @property description Description of the elastic filter rule
 * @property id Id of the elastic filter rule
 * @property source IP of the elastic filter rule
 */
public data class ElasticTrafficFilterRuleResponse(
    public val azureEndpointGuid: String? = null,
    public val azureEndpointName: String? = null,
    public val description: String? = null,
    public val id: String? = null,
    public val source: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ElasticTrafficFilterRuleResponse): ElasticTrafficFilterRuleResponse = ElasticTrafficFilterRuleResponse(
            azureEndpointGuid = javaType.azureEndpointGuid().map({ args0 -> args0 }).orElse(null),
            azureEndpointName = javaType.azureEndpointName().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
        )
    }
}
