@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The definition of a filtering tag. Filtering tags are used for capturing resources and include/exclude them from being monitored.
 * @property action Valid actions for a filtering tag.
 * @property name The name (also known as the key) of the tag.
 * @property value The value of the tag.
 */
public data class FilteringTagResponse(
    public val action: String? = null,
    public val name: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.FilteringTagResponse): FilteringTagResponse = FilteringTagResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
