@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.Suppress

/**
 * Marketplace Subscription and Organization details to which resource gets billed into.
 * @property marketplaceSaasInfo Marketplace Subscription details
 * @property partnerBillingEntity Partner Billing Entity details: Organization Info
 */
public data class GetBillingInfoResult(
    public val marketplaceSaasInfo: MarketplaceSaaSInfoResponse? = null,
    public val partnerBillingEntity: PartnerBillingEntityResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.GetBillingInfoResult): GetBillingInfoResult = GetBillingInfoResult(
            marketplaceSaasInfo = javaType.marketplaceSaasInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.MarketplaceSaaSInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            partnerBillingEntity = javaType.partnerBillingEntity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.PartnerBillingEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
