@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Capture properties of Open AI resource Integration.
 * @property id The id of the integration.
 * @property name Name of the integration.
 * @property properties Open AI Integration details.
 * @property type The type of the integration.
 */
public data class GetOpenAIResult(
    public val id: String,
    public val name: String,
    public val properties: OpenAIIntegrationPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.GetOpenAIResult): GetOpenAIResult = GetOpenAIResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.elastic.kotlin.outputs.OpenAIIntegrationPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
