@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Capture logs and metrics of Azure resources based on ARM tags.
 * @property id The id of the rule set.
 * @property name Name of the rule set.
 * @property properties Properties of the monitoring tag rules.
 * @property systemData The system metadata relating to this resource
 * @property type The type of the rule set.
 */
public data class GetTagRuleResult(
    public val id: String,
    public val name: String,
    public val properties: MonitoringTagRulesPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.GetTagRuleResult): GetTagRuleResult = GetTagRuleResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.elastic.kotlin.outputs.MonitoringTagRulesPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.elastic.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
