@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *  List of all active elastic deployments.
 * @property nextLink Link to the next set of results, if any.
 * @property value Results of a list operation.
 */
public data class ListConnectedPartnerResourceResult(
    public val nextLink: String? = null,
    public val `value`: List<ConnectedPartnerResourcesListFormatResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ListConnectedPartnerResourceResult): ListConnectedPartnerResourceResult = ListConnectedPartnerResourceResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.ConnectedPartnerResourcesListFormatResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
