@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of deployment in Elastic cloud corresponding to the Elastic monitor resource.
 * @property deploymentUrl Deployment URL of the elasticsearch in Elastic cloud deployment.
 * @property diskCapacity Disk capacity of the elasticsearch in Elastic cloud deployment.
 * @property marketplaceSaasInfo Marketplace SaaS Info of the resource.
 * @property memoryCapacity RAM capacity of the elasticsearch in Elastic cloud deployment.
 * @property status The Elastic deployment status.
 * @property version Version of the elasticsearch in Elastic cloud deployment.
 */
public data class ListDeploymentInfoResult(
    public val deploymentUrl: String,
    public val diskCapacity: String,
    public val marketplaceSaasInfo: MarketplaceSaaSInfoResponse,
    public val memoryCapacity: String,
    public val status: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ListDeploymentInfoResult): ListDeploymentInfoResult = ListDeploymentInfoResult(
            deploymentUrl = javaType.deploymentUrl(),
            diskCapacity = javaType.diskCapacity(),
            marketplaceSaasInfo = javaType.marketplaceSaasInfo().let({ args0 ->
                com.pulumi.azurenative.elastic.kotlin.outputs.MarketplaceSaaSInfoResponse.Companion.toKotlin(args0)
            }),
            memoryCapacity = javaType.memoryCapacity(),
            status = javaType.status(),
            version = javaType.version(),
        )
    }
}
