@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response of a list operation.
 * @property nextLink Link to the next set of results, if any.
 * @property value Results of a list operation.
 */
public data class ListMonitoredResourceResult(
    public val nextLink: String? = null,
    public val `value`: List<MonitoredResourceResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ListMonitoredResourceResult): ListMonitoredResourceResult = ListMonitoredResourceResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.MonitoredResourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
