@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response of a list operation.
 * @property nextLink Link to the next Vm resource Id, if any.
 * @property value Results of a list operation.
 */
public data class ListVMHostResult(
    public val nextLink: String? = null,
    public val `value`: List<VMResourcesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ListVMHostResult): ListVMHostResult = ListVMHostResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.VMResourcesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
