@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Marketplace SAAS Info of the resource.
 * @property billedAzureSubscriptionId The Azure Subscription ID to which the Marketplace Subscription belongs and gets billed into.
 * @property marketplaceName Marketplace Subscription Details: SAAS Name
 * @property marketplaceResourceId Marketplace Subscription Details: Resource URI
 * @property marketplaceStatus Marketplace Subscription Details: SaaS Subscription Status
 * @property marketplaceSubscription Marketplace Subscription
 * @property subscribed Flag specifying if the Marketplace status is subscribed or not.
 */
public data class MarketplaceSaaSInfoResponse(
    public val billedAzureSubscriptionId: String? = null,
    public val marketplaceName: String? = null,
    public val marketplaceResourceId: String? = null,
    public val marketplaceStatus: String? = null,
    public val marketplaceSubscription: MarketplaceSaaSInfoResponseMarketplaceSubscription? = null,
    public val subscribed: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.MarketplaceSaaSInfoResponse): MarketplaceSaaSInfoResponse = MarketplaceSaaSInfoResponse(
            billedAzureSubscriptionId = javaType.billedAzureSubscriptionId().map({ args0 ->
                args0
            }).orElse(null),
            marketplaceName = javaType.marketplaceName().map({ args0 -> args0 }).orElse(null),
            marketplaceResourceId = javaType.marketplaceResourceId().map({ args0 -> args0 }).orElse(null),
            marketplaceStatus = javaType.marketplaceStatus().map({ args0 -> args0 }).orElse(null),
            marketplaceSubscription = javaType.marketplaceSubscription().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.MarketplaceSaaSInfoResponseMarketplaceSubscription.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subscribed = javaType.subscribed().map({ args0 -> args0 }).orElse(null),
        )
    }
}
