@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties specific to the monitor resource.
 * @property elasticProperties Elastic cloud properties.
 * @property generateApiKey Flag to determine if User API Key has to be generated and shared.
 * @property liftrResourceCategory
 * @property liftrResourcePreference The priority of the resource.
 * @property monitoringStatus Flag specifying if the resource monitoring is enabled or disabled.
 * @property provisioningState Provisioning state of the monitor resource.
 * @property version Version of elastic of the monitor resource
 */
public data class MonitorPropertiesResponse(
    public val elasticProperties: ElasticPropertiesResponse? = null,
    public val generateApiKey: Boolean? = null,
    public val liftrResourceCategory: String,
    public val liftrResourcePreference: Int,
    public val monitoringStatus: String? = null,
    public val provisioningState: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.MonitorPropertiesResponse): MonitorPropertiesResponse = MonitorPropertiesResponse(
            elasticProperties = javaType.elasticProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.ElasticPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            generateApiKey = javaType.generateApiKey().map({ args0 -> args0 }).orElse(null),
            liftrResourceCategory = javaType.liftrResourceCategory(),
            liftrResourcePreference = javaType.liftrResourcePreference(),
            monitoringStatus = javaType.monitoringStatus().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
