@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a resource currently being monitored by the Elastic monitor resource.
 * @property id The ARM id of the resource.
 * @property reasonForLogsStatus Reason for why the resource is sending logs (or why it is not sending).
 * @property sendingLogs Flag indicating the status of the resource for sending logs operation to Elastic.
 */
public data class MonitoredResourceResponse(
    public val id: String? = null,
    public val reasonForLogsStatus: String? = null,
    public val sendingLogs: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.MonitoredResourceResponse): MonitoredResourceResponse = MonitoredResourceResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            reasonForLogsStatus = javaType.reasonForLogsStatus().map({ args0 -> args0 }).orElse(null),
            sendingLogs = javaType.sendingLogs().map({ args0 -> args0 }).orElse(null),
        )
    }
}
