@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The list of subscriptions and it's monitoring status by current Elastic monitor.
 * @property error The reason of not monitoring the subscription.
 * @property status The state of monitoring.
 * @property subscriptionId The subscriptionId to be monitored.
 * @property tagRules Definition of the properties for a TagRules resource.
 */
public data class MonitoredSubscriptionResponse(
    public val error: String? = null,
    public val status: String? = null,
    public val subscriptionId: String? = null,
    public val tagRules: MonitoringTagRulesPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.MonitoredSubscriptionResponse): MonitoredSubscriptionResponse = MonitoredSubscriptionResponse(
            error = javaType.error().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tagRules = javaType.tagRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.MonitoringTagRulesPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
