@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of the properties for a TagRules resource.
 * @property logRules Rules for sending logs.
 * @property provisioningState Provisioning state of the monitoring tag rules.
 */
public data class MonitoringTagRulesPropertiesResponse(
    public val logRules: LogRulesResponse? = null,
    public val provisioningState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.MonitoringTagRulesPropertiesResponse): MonitoringTagRulesPropertiesResponse = MonitoringTagRulesPropertiesResponse(
            logRules = javaType.logRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.LogRulesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
