@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Partner Billing details associated with the resource.
 * @property id The Elastic Organization Id.
 * @property name The Elastic Organization Name.
 * @property partnerEntityUri Link to the elastic organization page
 */
public data class PartnerBillingEntityResponse(
    public val id: String? = null,
    public val name: String? = null,
    public val partnerEntityUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.PartnerBillingEntityResponse): PartnerBillingEntityResponse = PartnerBillingEntityResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            partnerEntityUri = javaType.partnerEntityUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
