@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The request to update subscriptions needed to be monitored by the Elastic monitor resource.
 * @property monitoredSubscriptionList List of subscriptions and the state of the monitoring.
 * @property provisioningState Provisioning State of the resource
 */
public data class SubscriptionListResponse(
    public val monitoredSubscriptionList: List<MonitoredSubscriptionResponse>? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.SubscriptionListResponse): SubscriptionListResponse = SubscriptionListResponse(
            monitoredSubscriptionList = javaType.monitoredSubscriptionList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.MonitoredSubscriptionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
