@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin

import com.pulumi.azurenative.elasticsan.ElasticSanArgs.builder
import com.pulumi.azurenative.elasticsan.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.elasticsan.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Response for ElasticSan request.
 * Azure REST API version: 2021-11-20-preview. Prior API version in Azure Native 1.x: 2021-11-20-preview.
 * Other available API versions: 2022-12-01-preview, 2023-01-01.
 * ## Example Usage
 * ### ElasticSans_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticSan = new AzureNative.ElasticSan.ElasticSan("elasticSan", new()
 *     {
 *         AvailabilityZones = new[]
 *         {
 *             "aaaaaaaaaaaaaaaaa",
 *         },
 *         BaseSizeTiB = 26,
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         ExtendedCapacitySizeTiB = 7,
 *         Location = "aaaaaaaaaaaaaaaaaaaaaaaaaaa",
 *         ResourceGroupName = "rgelasticsan",
 *         Sku = new AzureNative.ElasticSan.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.ElasticSan.SkuName.Premium_LRS,
 *             Tier = AzureNative.ElasticSan.SkuTier.Premium,
 *         },
 *         Tags =
 *         {
 *             { "key896", "aaaaaaaaaaaaaaaaaa" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewElasticSan(ctx, "elasticSan", &elasticsan.ElasticSanArgs{
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("aaaaaaaaaaaaaaaaa"),
 * 			},
 * 			BaseSizeTiB:             pulumi.Float64(26),
 * 			ElasticSanName:          pulumi.String("ti7q-k952-1qB3J_5"),
 * 			ExtendedCapacitySizeTiB: pulumi.Float64(7),
 * 			Location:                pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * 			ResourceGroupName:       pulumi.String("rgelasticsan"),
 * 			Sku: &elasticsan.SkuArgs{
 * 				Name: pulumi.String(elasticsan.SkuName_Premium_LRS),
 * 				Tier: pulumi.String(elasticsan.SkuTierPremium),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key896": pulumi.String("aaaaaaaaaaaaaaaaaa"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.ElasticSan;
 * import com.pulumi.azurenative.elasticsan.ElasticSanArgs;
 * import com.pulumi.azurenative.elasticsan.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticSan = new ElasticSan("elasticSan", ElasticSanArgs.builder()
 *             .availabilityZones("aaaaaaaaaaaaaaaaa")
 *             .baseSizeTiB(26)
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .extendedCapacitySizeTiB(7)
 *             .location("aaaaaaaaaaaaaaaaaaaaaaaaaaa")
 *             .resourceGroupName("rgelasticsan")
 *             .sku(SkuArgs.builder()
 *                 .name("Premium_LRS")
 *                 .tier("Premium")
 *                 .build())
 *             .tags(Map.of("key896", "aaaaaaaaaaaaaaaaaa"))
 *             .build());
 *     }
 * }
 * ```
 * ### ElasticSans_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticSan = new AzureNative.ElasticSan.ElasticSan("elasticSan", new()
 *     {
 *         BaseSizeTiB = 26,
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         ExtendedCapacitySizeTiB = 7,
 *         ResourceGroupName = "rgelasticsan",
 *         Sku = new AzureNative.ElasticSan.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.ElasticSan.SkuName.Premium_LRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewElasticSan(ctx, "elasticSan", &elasticsan.ElasticSanArgs{
 * 			BaseSizeTiB:             pulumi.Float64(26),
 * 			ElasticSanName:          pulumi.String("ti7q-k952-1qB3J_5"),
 * 			ExtendedCapacitySizeTiB: pulumi.Float64(7),
 * 			ResourceGroupName:       pulumi.String("rgelasticsan"),
 * 			Sku: &elasticsan.SkuArgs{
 * 				Name: pulumi.String(elasticsan.SkuName_Premium_LRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.ElasticSan;
 * import com.pulumi.azurenative.elasticsan.ElasticSanArgs;
 * import com.pulumi.azurenative.elasticsan.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticSan = new ElasticSan("elasticSan", ElasticSanArgs.builder()
 *             .baseSizeTiB(26)
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .extendedCapacitySizeTiB(7)
 *             .resourceGroupName("rgelasticsan")
 *             .sku(SkuArgs.builder()
 *                 .name("Premium_LRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elasticsan:ElasticSan aaaaaaaaaaa /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}
 * ```
 * @property availabilityZones Logical zone for Elastic San resource; example: ["1"].
 * @property baseSizeTiB Base size of the Elastic San appliance in TiB.
 * @property elasticSanName The name of the ElasticSan.
 * @property extendedCapacitySizeTiB Extended size of the Elastic San appliance in TiB.
 * @property location The geo-location where the resource lives.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku resource sku
 * @property tags Azure resource tags.
 */
public data class ElasticSanArgs(
    public val availabilityZones: Output<List<String>>? = null,
    public val baseSizeTiB: Output<Double>? = null,
    public val elasticSanName: Output<String>? = null,
    public val extendedCapacitySizeTiB: Output<Double>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.ElasticSanArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.ElasticSanArgs =
        com.pulumi.azurenative.elasticsan.ElasticSanArgs.builder()
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .baseSizeTiB(baseSizeTiB?.applyValue({ args0 -> args0 }))
            .elasticSanName(elasticSanName?.applyValue({ args0 -> args0 }))
            .extendedCapacitySizeTiB(extendedCapacitySizeTiB?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ElasticSanArgs].
 */
@PulumiTagMarker
public class ElasticSanArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var baseSizeTiB: Output<Double>? = null

    private var elasticSanName: Output<String>? = null

    private var extendedCapacitySizeTiB: Output<Double>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Logical zone for Elastic San resource; example: ["1"].
     */
    @JvmName("lddopgklvyutwyns")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("agfpjkcpltjgsmey")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values Logical zone for Elastic San resource; example: ["1"].
     */
    @JvmName("hdcibngojnuiwkpu")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value Base size of the Elastic San appliance in TiB.
     */
    @JvmName("mbreswvgjtxnyrnu")
    public suspend fun baseSizeTiB(`value`: Output<Double>) {
        this.baseSizeTiB = value
    }

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("gtuorugorkmintdh")
    public suspend fun elasticSanName(`value`: Output<String>) {
        this.elasticSanName = value
    }

    /**
     * @param value Extended size of the Elastic San appliance in TiB.
     */
    @JvmName("lvutyeqcgpdpurii")
    public suspend fun extendedCapacitySizeTiB(`value`: Output<Double>) {
        this.extendedCapacitySizeTiB = value
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("orqufuscuglbeyhs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yynlsnckooplfqwx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value resource sku
     */
    @JvmName("ngyvjljdvvaduwce")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("mpqiwqhuywmcbkpt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Logical zone for Elastic San resource; example: ["1"].
     */
    @JvmName("fefkelpatmxuxjip")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values Logical zone for Elastic San resource; example: ["1"].
     */
    @JvmName("eqsjhvoxcktbpgxy")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value Base size of the Elastic San appliance in TiB.
     */
    @JvmName("gkhoeoeskjljpkwd")
    public suspend fun baseSizeTiB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseSizeTiB = mapped
    }

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("ykfgqyujxucxaiga")
    public suspend fun elasticSanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticSanName = mapped
    }

    /**
     * @param value Extended size of the Elastic San appliance in TiB.
     */
    @JvmName("qvamocbvemhuerue")
    public suspend fun extendedCapacitySizeTiB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedCapacitySizeTiB = mapped
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("vcywcyqfqjymfvvm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("evxckelubixbylbo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value resource sku
     */
    @JvmName("whakkitqviopbbsp")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument resource sku
     */
    @JvmName("mvhnyhcinrlohvvm")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("leanrskihricifpr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Azure resource tags.
     */
    @JvmName("ohgmdhoikobxgdol")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ElasticSanArgs = ElasticSanArgs(
        availabilityZones = availabilityZones,
        baseSizeTiB = baseSizeTiB,
        elasticSanName = elasticSanName,
        extendedCapacitySizeTiB = extendedCapacitySizeTiB,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
