@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin

import com.pulumi.azurenative.elasticsan.kotlin.outputs.IscsiTargetInfoResponse
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SourceCreationDataResponse
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.elasticsan.kotlin.outputs.IscsiTargetInfoResponse.Companion.toKotlin as iscsiTargetInfoResponseToKotlin
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SourceCreationDataResponse.Companion.toKotlin as sourceCreationDataResponseToKotlin
import com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Volume].
 */
@PulumiTagMarker
public class VolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VolumeArgs = VolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VolumeArgsBuilder.() -> Unit) {
        val builder = VolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Volume {
        val builtJavaResource = com.pulumi.azurenative.elasticsan.Volume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Volume(builtJavaResource)
    }
}

/**
 * Response for Volume request.
 * Azure REST API version: 2021-11-20-preview. Prior API version in Azure Native 1.x: 2021-11-20-preview.
 * Other available API versions: 2022-12-01-preview, 2023-01-01.
 * ## Example Usage
 * ### Volumes_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.ElasticSan.Volume("volume", new()
 *     {
 *         CreationData = new AzureNative.ElasticSan.Inputs.SourceCreationDataArgs
 *         {
 *             CreateSource = AzureNative.ElasticSan.VolumeCreateOption.None,
 *             SourceUri = "aaaaaa",
 *         },
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         ResourceGroupName = "rgelasticsan",
 *         SizeGiB = 22,
 *         Tags =
 *         {
 *             { "key7423", "aaaa" },
 *         },
 *         VolumeGroupName = "u_5I_1j4t3",
 *         VolumeName = "9132y",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolume(ctx, "volume", &elasticsan.VolumeArgs{
 * 			CreationData: &elasticsan.SourceCreationDataArgs{
 * 				CreateSource: elasticsan.VolumeCreateOptionNone,
 * 				SourceUri:    pulumi.String("aaaaaa"),
 * 			},
 * 			ElasticSanName:    pulumi.String("ti7q-k952-1qB3J_5"),
 * 			ResourceGroupName: pulumi.String("rgelasticsan"),
 * 			SizeGiB:           pulumi.Float64(22),
 * 			Tags: pulumi.StringMap{
 * 				"key7423": pulumi.String("aaaa"),
 * 			},
 * 			VolumeGroupName: pulumi.String("u_5I_1j4t3"),
 * 			VolumeName:      pulumi.String("9132y"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.Volume;
 * import com.pulumi.azurenative.elasticsan.VolumeArgs;
 * import com.pulumi.azurenative.elasticsan.inputs.SourceCreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .creationData(SourceCreationDataArgs.builder()
 *                 .createSource("None")
 *                 .sourceUri("aaaaaa")
 *                 .build())
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .resourceGroupName("rgelasticsan")
 *             .sizeGiB(22)
 *             .tags(Map.of("key7423", "aaaa"))
 *             .volumeGroupName("u_5I_1j4t3")
 *             .volumeName("9132y")
 *             .build());
 *     }
 * }
 * ```
 * ### Volumes_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.ElasticSan.Volume("volume", new()
 *     {
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         ResourceGroupName = "rgelasticsan",
 *         VolumeGroupName = "u_5I_1j4t3",
 *         VolumeName = "9132y",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolume(ctx, "volume", &elasticsan.VolumeArgs{
 * 			ElasticSanName:    pulumi.String("ti7q-k952-1qB3J_5"),
 * 			ResourceGroupName: pulumi.String("rgelasticsan"),
 * 			VolumeGroupName:   pulumi.String("u_5I_1j4t3"),
 * 			VolumeName:        pulumi.String("9132y"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.Volume;
 * import com.pulumi.azurenative.elasticsan.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .resourceGroupName("rgelasticsan")
 *             .volumeGroupName("u_5I_1j4t3")
 *             .volumeName("9132y")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elasticsan:Volume aaaaaaaaaaaa /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}
 * ```
 */
public class Volume internal constructor(
    override val javaResource: com.pulumi.azurenative.elasticsan.Volume,
) : KotlinCustomResource(javaResource, VolumeMapper) {
    /**
     * State of the operation on the resource.
     */
    public val creationData: Output<SourceCreationDataResponse>?
        get() = javaResource.creationData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    sourceCreationDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Volume size.
     */
    public val sizeGiB: Output<Double>?
        get() = javaResource.sizeGiB().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Storage target information
     */
    public val storageTarget: Output<IscsiTargetInfoResponse>
        get() = javaResource.storageTarget().applyValue({ args0 ->
            args0.let({ args0 ->
                iscsiTargetInfoResponseToKotlin(args0)
            })
        })

    /**
     * Resource metadata required by ARM RPC
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Azure resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique Id of the volume in GUID format
     */
    public val volumeId: Output<String>
        get() = javaResource.volumeId().applyValue({ args0 -> args0 })
}

public object VolumeMapper : ResourceMapper<Volume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.elasticsan.Volume::class == javaResource::class

    override fun map(javaResource: Resource): Volume = Volume(
        javaResource as
            com.pulumi.azurenative.elasticsan.Volume,
    )
}

/**
 * @see [Volume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Volume].
 */
public suspend fun volume(name: String, block: suspend VolumeResourceBuilder.() -> Unit): Volume {
    val builder = VolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Volume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun volume(name: String): Volume {
    val builder = VolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
