@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin

import com.pulumi.azurenative.elasticsan.VolumeArgs.builder
import com.pulumi.azurenative.elasticsan.kotlin.inputs.SourceCreationDataArgs
import com.pulumi.azurenative.elasticsan.kotlin.inputs.SourceCreationDataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Response for Volume request.
 * Azure REST API version: 2021-11-20-preview. Prior API version in Azure Native 1.x: 2021-11-20-preview.
 * Other available API versions: 2022-12-01-preview, 2023-01-01.
 * ## Example Usage
 * ### Volumes_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.ElasticSan.Volume("volume", new()
 *     {
 *         CreationData = new AzureNative.ElasticSan.Inputs.SourceCreationDataArgs
 *         {
 *             CreateSource = AzureNative.ElasticSan.VolumeCreateOption.None,
 *             SourceUri = "aaaaaa",
 *         },
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         ResourceGroupName = "rgelasticsan",
 *         SizeGiB = 22,
 *         Tags =
 *         {
 *             { "key7423", "aaaa" },
 *         },
 *         VolumeGroupName = "u_5I_1j4t3",
 *         VolumeName = "9132y",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolume(ctx, "volume", &elasticsan.VolumeArgs{
 * 			CreationData: &elasticsan.SourceCreationDataArgs{
 * 				CreateSource: elasticsan.VolumeCreateOptionNone,
 * 				SourceUri:    pulumi.String("aaaaaa"),
 * 			},
 * 			ElasticSanName:    pulumi.String("ti7q-k952-1qB3J_5"),
 * 			ResourceGroupName: pulumi.String("rgelasticsan"),
 * 			SizeGiB:           pulumi.Float64(22),
 * 			Tags: pulumi.StringMap{
 * 				"key7423": pulumi.String("aaaa"),
 * 			},
 * 			VolumeGroupName: pulumi.String("u_5I_1j4t3"),
 * 			VolumeName:      pulumi.String("9132y"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.Volume;
 * import com.pulumi.azurenative.elasticsan.VolumeArgs;
 * import com.pulumi.azurenative.elasticsan.inputs.SourceCreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .creationData(SourceCreationDataArgs.builder()
 *                 .createSource("None")
 *                 .sourceUri("aaaaaa")
 *                 .build())
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .resourceGroupName("rgelasticsan")
 *             .sizeGiB(22)
 *             .tags(Map.of("key7423", "aaaa"))
 *             .volumeGroupName("u_5I_1j4t3")
 *             .volumeName("9132y")
 *             .build());
 *     }
 * }
 * ```
 * ### Volumes_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.ElasticSan.Volume("volume", new()
 *     {
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         ResourceGroupName = "rgelasticsan",
 *         VolumeGroupName = "u_5I_1j4t3",
 *         VolumeName = "9132y",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolume(ctx, "volume", &elasticsan.VolumeArgs{
 * 			ElasticSanName:    pulumi.String("ti7q-k952-1qB3J_5"),
 * 			ResourceGroupName: pulumi.String("rgelasticsan"),
 * 			VolumeGroupName:   pulumi.String("u_5I_1j4t3"),
 * 			VolumeName:        pulumi.String("9132y"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.Volume;
 * import com.pulumi.azurenative.elasticsan.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .resourceGroupName("rgelasticsan")
 *             .volumeGroupName("u_5I_1j4t3")
 *             .volumeName("9132y")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elasticsan:Volume aaaaaaaaaaaa /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}
 * ```
 * @property creationData State of the operation on the resource.
 * @property elasticSanName The name of the ElasticSan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sizeGiB Volume size.
 * @property tags Azure resource tags.
 * @property volumeGroupName The name of the VolumeGroup.
 * @property volumeName The name of the Volume.
 */
public data class VolumeArgs(
    public val creationData: Output<SourceCreationDataArgs>? = null,
    public val elasticSanName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sizeGiB: Output<Double>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val volumeGroupName: Output<String>? = null,
    public val volumeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.VolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.VolumeArgs =
        com.pulumi.azurenative.elasticsan.VolumeArgs.builder()
            .creationData(creationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .elasticSanName(elasticSanName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sizeGiB(sizeGiB?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .volumeGroupName(volumeGroupName?.applyValue({ args0 -> args0 }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeArgs].
 */
@PulumiTagMarker
public class VolumeArgsBuilder internal constructor() {
    private var creationData: Output<SourceCreationDataArgs>? = null

    private var elasticSanName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sizeGiB: Output<Double>? = null

    private var tags: Output<Map<String, String>>? = null

    private var volumeGroupName: Output<String>? = null

    private var volumeName: Output<String>? = null

    /**
     * @param value State of the operation on the resource.
     */
    @JvmName("qfnjwdfcclwsdtji")
    public suspend fun creationData(`value`: Output<SourceCreationDataArgs>) {
        this.creationData = value
    }

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("yuhqrbrdndfjkkjj")
    public suspend fun elasticSanName(`value`: Output<String>) {
        this.elasticSanName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aghefocgexlfgria")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Volume size.
     */
    @JvmName("ikvfvkjurtxngngf")
    public suspend fun sizeGiB(`value`: Output<Double>) {
        this.sizeGiB = value
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("hxjdkobxjtskhfjt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the VolumeGroup.
     */
    @JvmName("jfdtxwfxnsyxunob")
    public suspend fun volumeGroupName(`value`: Output<String>) {
        this.volumeGroupName = value
    }

    /**
     * @param value The name of the Volume.
     */
    @JvmName("vexbrbelmrxrvium")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value State of the operation on the resource.
     */
    @JvmName("htqjqfcbprbghdch")
    public suspend fun creationData(`value`: SourceCreationDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationData = mapped
    }

    /**
     * @param argument State of the operation on the resource.
     */
    @JvmName("jcwhuwrslblmhwey")
    public suspend fun creationData(argument: suspend SourceCreationDataArgsBuilder.() -> Unit) {
        val toBeMapped = SourceCreationDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.creationData = mapped
    }

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("qmokonwycvavyral")
    public suspend fun elasticSanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticSanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dbngdbwnipdhyocb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Volume size.
     */
    @JvmName("xnirmnxleddrntar")
    public suspend fun sizeGiB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeGiB = mapped
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("mjnoecoimxnraoec")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Azure resource tags.
     */
    @JvmName("tcfvsshfattdfwuq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the VolumeGroup.
     */
    @JvmName("sgksfrmqdfkxorhl")
    public suspend fun volumeGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeGroupName = mapped
    }

    /**
     * @param value The name of the Volume.
     */
    @JvmName("iencslkfgxrqveib")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    internal fun build(): VolumeArgs = VolumeArgs(
        creationData = creationData,
        elasticSanName = elasticSanName,
        resourceGroupName = resourceGroupName,
        sizeGiB = sizeGiB,
        tags = tags,
        volumeGroupName = volumeGroupName,
        volumeName = volumeName,
    )
}
