@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin

import com.pulumi.azurenative.elasticsan.VolumeSnapshotArgs.builder
import com.pulumi.azurenative.elasticsan.kotlin.inputs.SnapshotCreationDataArgs
import com.pulumi.azurenative.elasticsan.kotlin.inputs.SnapshotCreationDataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Response for Volume Snapshot request.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### VolumeSnapshots_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeSnapshot = new AzureNative.ElasticSan.VolumeSnapshot("volumeSnapshot", new()
 *     {
 *         CreationData = new AzureNative.ElasticSan.Inputs.SnapshotCreationDataArgs
 *         {
 *             SourceId = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}",
 *         },
 *         ElasticSanName = "elasticsanname",
 *         ResourceGroupName = "resourcegroupname",
 *         SnapshotName = "snapshotname",
 *         VolumeGroupName = "volumegroupname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolumeSnapshot(ctx, "volumeSnapshot", &elasticsan.VolumeSnapshotArgs{
 * 			CreationData: &elasticsan.SnapshotCreationDataArgs{
 * 				SourceId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}"),
 * 			},
 * 			ElasticSanName:    pulumi.String("elasticsanname"),
 * 			ResourceGroupName: pulumi.String("resourcegroupname"),
 * 			SnapshotName:      pulumi.String("snapshotname"),
 * 			VolumeGroupName:   pulumi.String("volumegroupname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.VolumeSnapshot;
 * import com.pulumi.azurenative.elasticsan.VolumeSnapshotArgs;
 * import com.pulumi.azurenative.elasticsan.inputs.SnapshotCreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeSnapshot = new VolumeSnapshot("volumeSnapshot", VolumeSnapshotArgs.builder()
 *             .creationData(SnapshotCreationDataArgs.builder()
 *                 .sourceId("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}")
 *                 .build())
 *             .elasticSanName("elasticsanname")
 *             .resourceGroupName("resourcegroupname")
 *             .snapshotName("snapshotname")
 *             .volumeGroupName("volumegroupname")
 *             .build());
 *     }
 * }
 * ```
 * ### VolumeSnapshots_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeSnapshot = new AzureNative.ElasticSan.VolumeSnapshot("volumeSnapshot", new()
 *     {
 *         CreationData = new AzureNative.ElasticSan.Inputs.SnapshotCreationDataArgs
 *         {
 *             SourceId = "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}",
 *         },
 *         ElasticSanName = "elasticsanname",
 *         ResourceGroupName = "resourcegroupname",
 *         SnapshotName = "snapshotname",
 *         VolumeGroupName = "volumegroupname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolumeSnapshot(ctx, "volumeSnapshot", &elasticsan.VolumeSnapshotArgs{
 * 			CreationData: &elasticsan.SnapshotCreationDataArgs{
 * 				SourceId: pulumi.String("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}"),
 * 			},
 * 			ElasticSanName:    pulumi.String("elasticsanname"),
 * 			ResourceGroupName: pulumi.String("resourcegroupname"),
 * 			SnapshotName:      pulumi.String("snapshotname"),
 * 			VolumeGroupName:   pulumi.String("volumegroupname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.VolumeSnapshot;
 * import com.pulumi.azurenative.elasticsan.VolumeSnapshotArgs;
 * import com.pulumi.azurenative.elasticsan.inputs.SnapshotCreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeSnapshot = new VolumeSnapshot("volumeSnapshot", VolumeSnapshotArgs.builder()
 *             .creationData(SnapshotCreationDataArgs.builder()
 *                 .sourceId("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}")
 *                 .build())
 *             .elasticSanName("elasticsanname")
 *             .resourceGroupName("resourcegroupname")
 *             .snapshotName("snapshotname")
 *             .volumeGroupName("volumegroupname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elasticsan:VolumeSnapshot qukfugetqthsufp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/snapshots/{snapshotName}
 * ```
 * @property creationData Data used when creating a volume snapshot.
 * @property elasticSanName The name of the ElasticSan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property snapshotName The name of the volume snapshot within the given volume group.
 * @property volumeGroupName The name of the VolumeGroup.
 */
public data class VolumeSnapshotArgs(
    public val creationData: Output<SnapshotCreationDataArgs>? = null,
    public val elasticSanName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val snapshotName: Output<String>? = null,
    public val volumeGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.VolumeSnapshotArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.VolumeSnapshotArgs =
        com.pulumi.azurenative.elasticsan.VolumeSnapshotArgs.builder()
            .creationData(creationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .elasticSanName(elasticSanName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 }))
            .volumeGroupName(volumeGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeSnapshotArgs].
 */
@PulumiTagMarker
public class VolumeSnapshotArgsBuilder internal constructor() {
    private var creationData: Output<SnapshotCreationDataArgs>? = null

    private var elasticSanName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var snapshotName: Output<String>? = null

    private var volumeGroupName: Output<String>? = null

    /**
     * @param value Data used when creating a volume snapshot.
     */
    @JvmName("mukkkpjybqdjsual")
    public suspend fun creationData(`value`: Output<SnapshotCreationDataArgs>) {
        this.creationData = value
    }

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("oqkbbwebgdigwikr")
    public suspend fun elasticSanName(`value`: Output<String>) {
        this.elasticSanName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bdvwnjnfgfiuxtno")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the volume snapshot within the given volume group.
     */
    @JvmName("wgdevedvntmuqccx")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value The name of the VolumeGroup.
     */
    @JvmName("heaxvvueaaarirhy")
    public suspend fun volumeGroupName(`value`: Output<String>) {
        this.volumeGroupName = value
    }

    /**
     * @param value Data used when creating a volume snapshot.
     */
    @JvmName("enmewaoxcsfjshjn")
    public suspend fun creationData(`value`: SnapshotCreationDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationData = mapped
    }

    /**
     * @param argument Data used when creating a volume snapshot.
     */
    @JvmName("qekroxgylmaktusg")
    public suspend fun creationData(argument: suspend SnapshotCreationDataArgsBuilder.() -> Unit) {
        val toBeMapped = SnapshotCreationDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.creationData = mapped
    }

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("nnqcvkbrssywgusn")
    public suspend fun elasticSanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticSanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rerkwuseyiqnyeah")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the volume snapshot within the given volume group.
     */
    @JvmName("oclpkpqlujnpomel")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    /**
     * @param value The name of the VolumeGroup.
     */
    @JvmName("dlhmjofedvrbqjim")
    public suspend fun volumeGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeGroupName = mapped
    }

    internal fun build(): VolumeSnapshotArgs = VolumeSnapshotArgs(
        creationData = creationData,
        elasticSanName = elasticSanName,
        resourceGroupName = resourceGroupName,
        snapshotName = snapshotName,
        volumeGroupName = volumeGroupName,
    )
}
