@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public enum class PrivateEndpointServiceConnectionStatus(
    public val javaValue: com.pulumi.azurenative.elasticsan.enums.PrivateEndpointServiceConnectionStatus,
) :
    ConvertibleToJava<com.pulumi.azurenative.elasticsan.enums.PrivateEndpointServiceConnectionStatus> {
    Pending(com.pulumi.azurenative.elasticsan.enums.PrivateEndpointServiceConnectionStatus.Pending),
    Approved(com.pulumi.azurenative.elasticsan.enums.PrivateEndpointServiceConnectionStatus.Approved),
    Failed(com.pulumi.azurenative.elasticsan.enums.PrivateEndpointServiceConnectionStatus.Failed),
    Rejected(com.pulumi.azurenative.elasticsan.enums.PrivateEndpointServiceConnectionStatus.Rejected),
    ;

    override fun toJava(): com.pulumi.azurenative.elasticsan.enums.PrivateEndpointServiceConnectionStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.enums.PrivateEndpointServiceConnectionStatus): PrivateEndpointServiceConnectionStatus =
            PrivateEndpointServiceConnectionStatus.values().first { it.javaValue == javaType }
    }
}
